package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.StringValueLength1to250
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourcePermission(
    permission: Optional[StringValueLength1to250] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ResourcePermission = {
    import ResourcePermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ResourcePermission
      .builder()
      .optionallyWith(
        permission.map(value =>
          StringValueLength1to250.unwrap(value): java.lang.String
        )
      )(_.permission)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ResourcePermission.ReadOnly =
    zio.aws.finspacedata.model.ResourcePermission.wrap(buildAwsValue())
}
object ResourcePermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ResourcePermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ResourcePermission =
      zio.aws.finspacedata.model
        .ResourcePermission(permission.map(value => value))
    def permission: Optional[StringValueLength1to250]
    def getPermission: ZIO[Any, AwsError, StringValueLength1to250] =
      AwsError.unwrapOptionField("permission", permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ResourcePermission
  ) extends zio.aws.finspacedata.model.ResourcePermission.ReadOnly {
    override val permission: Optional[StringValueLength1to250] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permission())
        .map(value =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to250(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ResourcePermission
  ): zio.aws.finspacedata.model.ResourcePermission.ReadOnly = new Wrapper(impl)
}
