package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{Password, UserId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResetUserPasswordResponse(
    userId: Optional[UserId] = Optional.Absent,
    temporaryPassword: Optional[Password] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordResponse = {
    import ResetUserPasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        temporaryPassword.map(value => Password.unwrap(value): java.lang.String)
      )(_.temporaryPassword)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly =
    zio.aws.finspacedata.model.ResetUserPasswordResponse.wrap(buildAwsValue())
}
object ResetUserPasswordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ResetUserPasswordResponse =
      zio.aws.finspacedata.model.ResetUserPasswordResponse(
        userId.map(value => value),
        temporaryPassword.map(value => value)
      )
    def userId: Optional[UserId]
    def temporaryPassword: Optional[Password]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getTemporaryPassword: ZIO[Any, AwsError, Password] =
      AwsError.unwrapOptionField("temporaryPassword", temporaryPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordResponse
  ) extends zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
    override val temporaryPassword: Optional[Password] = zio.aws.core.internal
      .optionalFromNullable(impl.temporaryPassword())
      .map(value => zio.aws.finspacedata.model.primitives.Password(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordResponse
  ): zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly =
    new Wrapper(impl)
}
