package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait LocationType {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.LocationType
}
object LocationType {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.LocationType
  ): zio.aws.finspacedata.model.LocationType = value match {
    case software.amazon.awssdk.services.finspacedata.model.LocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.LocationType.INGESTION =>
      val r = INGESTION
      r
    case software.amazon.awssdk.services.finspacedata.model.LocationType.SAGEMAKER =>
      val r = SAGEMAKER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.LocationType =
      software.amazon.awssdk.services.finspacedata.model.LocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object INGESTION extends zio.aws.finspacedata.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.LocationType =
      software.amazon.awssdk.services.finspacedata.model.LocationType.INGESTION
  }
  case object SAGEMAKER extends zio.aws.finspacedata.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.LocationType =
      software.amazon.awssdk.services.finspacedata.model.LocationType.SAGEMAKER
  }
}
