package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListUsersByPermissionGroupResponse(
    users: Optional[
      Iterable[zio.aws.finspacedata.model.UserByPermissionGroup]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupResponse = {
    import ListUsersByPermissionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse.ReadOnly =
    zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse
      .wrap(buildAwsValue())
}
object ListUsersByPermissionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse =
      zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def users: Optional[
      List[zio.aws.finspacedata.model.UserByPermissionGroup.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getUsers: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.UserByPermissionGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupResponse
  ) extends zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse.ReadOnly {
    override val users: Optional[
      List[zio.aws.finspacedata.model.UserByPermissionGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.users())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.UserByPermissionGroup.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupResponse
  ): zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse.ReadOnly =
    new Wrapper(impl)
}
