package zio.aws.finspacedata.model
import zio.prelude.data.Optional
import zio.aws.finspacedata.model.primitives.{
  ResultLimit,
  PaginationToken,
  PermissionGroupId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListUsersByPermissionGroupRequest(
    permissionGroupId: PermissionGroupId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: ResultLimit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupRequest = {
    import ListUsersByPermissionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupRequest
      .builder()
      .permissionGroupId(
        PermissionGroupId.unwrap(permissionGroupId): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .maxResults(ResultLimit.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.ListUsersByPermissionGroupRequest.ReadOnly =
    zio.aws.finspacedata.model.ListUsersByPermissionGroupRequest
      .wrap(buildAwsValue())
}
object ListUsersByPermissionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.ListUsersByPermissionGroupRequest =
      zio.aws.finspacedata.model.ListUsersByPermissionGroupRequest(
        permissionGroupId,
        nextToken.map(value => value),
        maxResults
      )
    def permissionGroupId: PermissionGroupId
    def nextToken: Optional[PaginationToken]
    def maxResults: ResultLimit
    def getPermissionGroupId: ZIO[Any, Nothing, PermissionGroupId] =
      ZIO.succeed(permissionGroupId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, ResultLimit] = ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupRequest
  ) extends zio.aws.finspacedata.model.ListUsersByPermissionGroupRequest.ReadOnly {
    override val permissionGroupId: PermissionGroupId =
      zio.aws.finspacedata.model.primitives
        .PermissionGroupId(impl.permissionGroupId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
    override val maxResults: ResultLimit =
      zio.aws.finspacedata.model.primitives.ResultLimit(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersByPermissionGroupRequest
  ): zio.aws.finspacedata.model.ListUsersByPermissionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
