package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPermissionGroupsByUserResponse(
    permissionGroups: Optional[
      Iterable[zio.aws.finspacedata.model.PermissionGroupByUser]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserResponse = {
    import ListPermissionGroupsByUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserResponse
      .builder()
      .optionallyWith(
        permissionGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissionGroups)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse.ReadOnly =
    zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse
      .wrap(buildAwsValue())
}
object ListPermissionGroupsByUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse =
      zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse(
        permissionGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def permissionGroups: Optional[
      List[zio.aws.finspacedata.model.PermissionGroupByUser.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getPermissionGroups: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.PermissionGroupByUser.ReadOnly
    ]] = AwsError.unwrapOptionField("permissionGroups", permissionGroups)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserResponse
  ) extends zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse.ReadOnly {
    override val permissionGroups: Optional[
      List[zio.aws.finspacedata.model.PermissionGroupByUser.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.PermissionGroupByUser.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserResponse
  ): zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse.ReadOnly =
    new Wrapper(impl)
}
