package zio.aws.finspacedata.model
import zio.prelude.data.Optional
import zio.aws.finspacedata.model.primitives.{
  ResultLimit,
  PaginationToken,
  UserId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPermissionGroupsByUserRequest(
    userId: UserId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: ResultLimit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserRequest = {
    import ListPermissionGroupsByUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .maxResults(ResultLimit.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.ListPermissionGroupsByUserRequest.ReadOnly =
    zio.aws.finspacedata.model.ListPermissionGroupsByUserRequest
      .wrap(buildAwsValue())
}
object ListPermissionGroupsByUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.ListPermissionGroupsByUserRequest =
      zio.aws.finspacedata.model.ListPermissionGroupsByUserRequest(
        userId,
        nextToken.map(value => value),
        maxResults
      )
    def userId: UserId
    def nextToken: Optional[PaginationToken]
    def maxResults: ResultLimit
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, ResultLimit] = ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserRequest
  ) extends zio.aws.finspacedata.model.ListPermissionGroupsByUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.finspacedata.model.primitives.UserId(impl.userId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
    override val maxResults: ResultLimit =
      zio.aws.finspacedata.model.primitives.ResultLimit(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsByUserRequest
  ): zio.aws.finspacedata.model.ListPermissionGroupsByUserRequest.ReadOnly =
    new Wrapper(impl)
}
