package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatasetsResponse(
    datasets: Optional[Iterable[zio.aws.finspacedata.model.Dataset]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListDatasetsResponse
      .builder()
      .optionallyWith(
        datasets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasets)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly =
    zio.aws.finspacedata.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListDatasetsResponse =
      zio.aws.finspacedata.model.ListDatasetsResponse(
        datasets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasets: Optional[List[zio.aws.finspacedata.model.Dataset.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getDatasets: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.Dataset.ReadOnly
    ]] = AwsError.unwrapOptionField("datasets", datasets)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDatasetsResponse
  ) extends zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly {
    override val datasets
        : Optional[List[zio.aws.finspacedata.model.Dataset.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.Dataset.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDatasetsResponse
  ): zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
