package zio.aws.finspacedata.model
import zio.prelude.data.Optional
import zio.aws.finspacedata.model.primitives.{ResultLimit, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDatasetsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest = {
    import ListDatasetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListDatasetsRequest.ReadOnly =
    zio.aws.finspacedata.model.ListDatasetsRequest.wrap(buildAwsValue())
}
object ListDatasetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListDatasetsRequest =
      zio.aws.finspacedata.model.ListDatasetsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultLimit]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest
  ) extends zio.aws.finspacedata.model.ListDatasetsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[ResultLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.finspacedata.model.primitives.ResultLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest
  ): zio.aws.finspacedata.model.ListDatasetsRequest.ReadOnly = new Wrapper(impl)
}
