package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataViewsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    dataViews: Optional[Iterable[zio.aws.finspacedata.model.DataViewSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse = {
    import ListDataViewsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        dataViews.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataViews)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly =
    zio.aws.finspacedata.model.ListDataViewsResponse.wrap(buildAwsValue())
}
object ListDataViewsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListDataViewsResponse =
      zio.aws.finspacedata.model.ListDataViewsResponse(
        nextToken.map(value => value),
        dataViews.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def dataViews
        : Optional[List[zio.aws.finspacedata.model.DataViewSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDataViews: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.DataViewSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("dataViews", dataViews)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse
  ) extends zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
    override val dataViews
        : Optional[List[zio.aws.finspacedata.model.DataViewSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataViews())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.DataViewSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDataViewsResponse
  ): zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly = new Wrapper(
    impl
  )
}
