package zio.aws.finspacedata.model
import zio.prelude.data.Optional
import zio.aws.finspacedata.model.primitives.{
  PaginationToken,
  ResultLimit,
  DatasetId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListChangesetsRequest(
    datasetId: DatasetId,
    maxResults: Optional[ResultLimit] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest = {
    import ListChangesetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest
      .builder()
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ResultLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListChangesetsRequest.ReadOnly =
    zio.aws.finspacedata.model.ListChangesetsRequest.wrap(buildAwsValue())
}
object ListChangesetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListChangesetsRequest =
      zio.aws.finspacedata.model.ListChangesetsRequest(
        datasetId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def datasetId: DatasetId
    def maxResults: Optional[ResultLimit]
    def nextToken: Optional[PaginationToken]
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getMaxResults: ZIO[Any, AwsError, ResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest
  ) extends zio.aws.finspacedata.model.ListChangesetsRequest.ReadOnly {
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val maxResults: Optional[ResultLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.finspacedata.model.primitives.ResultLimit(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest
  ): zio.aws.finspacedata.model.ListChangesetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
