package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetWorkingLocationRequest(
    locationType: Optional[zio.aws.finspacedata.model.LocationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest = {
    import GetWorkingLocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest
      .builder()
      .optionallyWith(locationType.map(value => value.unwrap))(_.locationType)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.GetWorkingLocationRequest.ReadOnly =
    zio.aws.finspacedata.model.GetWorkingLocationRequest.wrap(buildAwsValue())
}
object GetWorkingLocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetWorkingLocationRequest =
      zio.aws.finspacedata.model
        .GetWorkingLocationRequest(locationType.map(value => value))
    def locationType: Optional[zio.aws.finspacedata.model.LocationType]
    def getLocationType
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.LocationType] =
      AwsError.unwrapOptionField("locationType", locationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest
  ) extends zio.aws.finspacedata.model.GetWorkingLocationRequest.ReadOnly {
    override val locationType
        : Optional[zio.aws.finspacedata.model.LocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationType())
        .map(value => zio.aws.finspacedata.model.LocationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest
  ): zio.aws.finspacedata.model.GetWorkingLocationRequest.ReadOnly =
    new Wrapper(impl)
}
