package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{IdType, SessionDuration}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetProgrammaticAccessCredentialsRequest(
    durationInMinutes: Optional[SessionDuration] = Optional.Absent,
    environmentId: IdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest = {
    import GetProgrammaticAccessCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest
      .builder()
      .optionallyWith(
        durationInMinutes.map(value =>
          SessionDuration.unwrap(value): java.lang.Long
        )
      )(_.durationInMinutes)
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsRequest.ReadOnly =
    zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsRequest
      .wrap(buildAwsValue())
}
object GetProgrammaticAccessCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsRequest =
      zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsRequest(
        durationInMinutes.map(value => value),
        environmentId
      )
    def durationInMinutes: Optional[SessionDuration]
    def environmentId: IdType
    def getDurationInMinutes: ZIO[Any, AwsError, SessionDuration] =
      AwsError.unwrapOptionField("durationInMinutes", durationInMinutes)
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest
  ) extends zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsRequest.ReadOnly {
    override val durationInMinutes: Optional[SessionDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInMinutes())
        .map(value =>
          zio.aws.finspacedata.model.primitives.SessionDuration(value)
        )
    override val environmentId: IdType =
      zio.aws.finspacedata.model.primitives.IdType(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest
  ): zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
