package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPermissionGroupResponse(
    permissionGroup: Optional[zio.aws.finspacedata.model.PermissionGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupResponse = {
    import GetPermissionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupResponse
      .builder()
      .optionallyWith(permissionGroup.map(value => value.buildAwsValue()))(
        _.permissionGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.GetPermissionGroupResponse.ReadOnly =
    zio.aws.finspacedata.model.GetPermissionGroupResponse.wrap(buildAwsValue())
}
object GetPermissionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetPermissionGroupResponse =
      zio.aws.finspacedata.model.GetPermissionGroupResponse(
        permissionGroup.map(value => value.asEditable)
      )
    def permissionGroup
        : Optional[zio.aws.finspacedata.model.PermissionGroup.ReadOnly]
    def getPermissionGroup: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.PermissionGroup.ReadOnly
    ] = AwsError.unwrapOptionField("permissionGroup", permissionGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupResponse
  ) extends zio.aws.finspacedata.model.GetPermissionGroupResponse.ReadOnly {
    override val permissionGroup
        : Optional[zio.aws.finspacedata.model.PermissionGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionGroup())
        .map(value => zio.aws.finspacedata.model.PermissionGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupResponse
  ): zio.aws.finspacedata.model.GetPermissionGroupResponse.ReadOnly =
    new Wrapper(impl)
}
