package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.finspacedata.model.primitives.PermissionGroupId
import scala.jdk.CollectionConverters.*
final case class GetPermissionGroupRequest(
    permissionGroupId: PermissionGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupRequest = {
    import GetPermissionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupRequest
      .builder()
      .permissionGroupId(
        PermissionGroupId.unwrap(permissionGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.GetPermissionGroupRequest.ReadOnly =
    zio.aws.finspacedata.model.GetPermissionGroupRequest.wrap(buildAwsValue())
}
object GetPermissionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetPermissionGroupRequest =
      zio.aws.finspacedata.model.GetPermissionGroupRequest(permissionGroupId)
    def permissionGroupId: PermissionGroupId
    def getPermissionGroupId: ZIO[Any, Nothing, PermissionGroupId] =
      ZIO.succeed(permissionGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupRequest
  ) extends zio.aws.finspacedata.model.GetPermissionGroupRequest.ReadOnly {
    override val permissionGroupId: PermissionGroupId =
      zio.aws.finspacedata.model.primitives
        .PermissionGroupId(impl.permissionGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetPermissionGroupRequest
  ): zio.aws.finspacedata.model.GetPermissionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
