package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetExternalDataViewAccessDetailsResponse(
    credentials: Optional[zio.aws.finspacedata.model.AwsCredentials] =
      Optional.Absent,
    s3Location: Optional[zio.aws.finspacedata.model.S3Location] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetExternalDataViewAccessDetailsResponse = {
    import GetExternalDataViewAccessDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetExternalDataViewAccessDetailsResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse.ReadOnly =
    zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse
      .wrap(buildAwsValue())
}
object GetExternalDataViewAccessDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetExternalDataViewAccessDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse =
      zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse(
        credentials.map(value => value.asEditable),
        s3Location.map(value => value.asEditable)
      )
    def credentials
        : Optional[zio.aws.finspacedata.model.AwsCredentials.ReadOnly]
    def s3Location: Optional[zio.aws.finspacedata.model.S3Location.ReadOnly]
    def getCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.AwsCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("credentials", credentials)
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetExternalDataViewAccessDetailsResponse
  ) extends zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse.ReadOnly {
    override val credentials
        : Optional[zio.aws.finspacedata.model.AwsCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.finspacedata.model.AwsCredentials.wrap(value))
    override val s3Location
        : Optional[zio.aws.finspacedata.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.finspacedata.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetExternalDataViewAccessDetailsResponse
  ): zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
