package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  DatasetArn,
  TimestampEpoch,
  DatasetDescription,
  AliasString,
  DatasetTitle,
  DatasetId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDatasetResponse(
    datasetId: Optional[DatasetId] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    datasetTitle: Optional[DatasetTitle] = Optional.Absent,
    kind: Optional[zio.aws.finspacedata.model.DatasetKind] = Optional.Absent,
    datasetDescription: Optional[DatasetDescription] = Optional.Absent,
    createTime: Optional[TimestampEpoch] = Optional.Absent,
    lastModifiedTime: Optional[TimestampEpoch] = Optional.Absent,
    schemaDefinition: Optional[zio.aws.finspacedata.model.SchemaUnion] =
      Optional.Absent,
    alias: Optional[AliasString] = Optional.Absent,
    status: Optional[zio.aws.finspacedata.model.DatasetStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetDatasetResponse = {
    import GetDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetDatasetResponse
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        datasetTitle.map(value => DatasetTitle.unwrap(value): java.lang.String)
      )(_.datasetTitle)
      .optionallyWith(kind.map(value => value.unwrap))(_.kind)
      .optionallyWith(
        datasetDescription.map(value =>
          DatasetDescription.unwrap(value): java.lang.String
        )
      )(_.datasetDescription)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .optionallyWith(schemaDefinition.map(value => value.buildAwsValue()))(
        _.schemaDefinition
      )
      .optionallyWith(
        alias.map(value => AliasString.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly =
    zio.aws.finspacedata.model.GetDatasetResponse.wrap(buildAwsValue())
}
object GetDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetDatasetResponse =
      zio.aws.finspacedata.model.GetDatasetResponse(
        datasetId.map(value => value),
        datasetArn.map(value => value),
        datasetTitle.map(value => value),
        kind.map(value => value),
        datasetDescription.map(value => value),
        createTime.map(value => value),
        lastModifiedTime.map(value => value),
        schemaDefinition.map(value => value.asEditable),
        alias.map(value => value),
        status.map(value => value)
      )
    def datasetId: Optional[DatasetId]
    def datasetArn: Optional[DatasetArn]
    def datasetTitle: Optional[DatasetTitle]
    def kind: Optional[zio.aws.finspacedata.model.DatasetKind]
    def datasetDescription: Optional[DatasetDescription]
    def createTime: Optional[TimestampEpoch]
    def lastModifiedTime: Optional[TimestampEpoch]
    def schemaDefinition
        : Optional[zio.aws.finspacedata.model.SchemaUnion.ReadOnly]
    def alias: Optional[AliasString]
    def status: Optional[zio.aws.finspacedata.model.DatasetStatus]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetTitle: ZIO[Any, AwsError, DatasetTitle] =
      AwsError.unwrapOptionField("datasetTitle", datasetTitle)
    def getKind: ZIO[Any, AwsError, zio.aws.finspacedata.model.DatasetKind] =
      AwsError.unwrapOptionField("kind", kind)
    def getDatasetDescription: ZIO[Any, AwsError, DatasetDescription] =
      AwsError.unwrapOptionField("datasetDescription", datasetDescription)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSchemaDefinition
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      AwsError.unwrapOptionField("schemaDefinition", schemaDefinition)
    def getAlias: ZIO[Any, AwsError, AliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDatasetResponse
  ) extends zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly {
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetArn(value))
    override val datasetTitle: Optional[DatasetTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetTitle())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetTitle(value))
    override val kind: Optional[zio.aws.finspacedata.model.DatasetKind] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kind())
        .map(value => zio.aws.finspacedata.model.DatasetKind.wrap(value))
    override val datasetDescription: Optional[DatasetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetDescription())
        .map(value =>
          zio.aws.finspacedata.model.primitives.DatasetDescription(value)
        )
    override val createTime: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastModifiedTime: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val schemaDefinition
        : Optional[zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaDefinition())
        .map(value => zio.aws.finspacedata.model.SchemaUnion.wrap(value))
    override val alias: Optional[AliasString] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.finspacedata.model.primitives.AliasString(value))
    override val status: Optional[zio.aws.finspacedata.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspacedata.model.DatasetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDatasetResponse
  ): zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly = new Wrapper(impl)
}
