package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait ExportFileFormat {
  def unwrap
      : software.amazon.awssdk.services.finspacedata.model.ExportFileFormat
}
object ExportFileFormat {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.ExportFileFormat
  ): zio.aws.finspacedata.model.ExportFileFormat = value match {
    case software.amazon.awssdk.services.finspacedata.model.ExportFileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.ExportFileFormat.PARQUET =>
      val r = PARQUET
      r
    case software.amazon.awssdk.services.finspacedata.model.ExportFileFormat.DELIMITED_TEXT =>
      val r = DELIMITED_TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.ExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ExportFileFormat =
      software.amazon.awssdk.services.finspacedata.model.ExportFileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object PARQUET extends zio.aws.finspacedata.model.ExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ExportFileFormat =
      software.amazon.awssdk.services.finspacedata.model.ExportFileFormat.PARQUET
  }
  case object DELIMITED_TEXT
      extends zio.aws.finspacedata.model.ExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ExportFileFormat =
      software.amazon.awssdk.services.finspacedata.model.ExportFileFormat.DELIMITED_TEXT
  }
}
