package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.UserId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnableUserResponse(
    userId: Optional[UserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.EnableUserResponse = {
    import EnableUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.EnableUserResponse.ReadOnly =
    zio.aws.finspacedata.model.EnableUserResponse.wrap(buildAwsValue())
}
object EnableUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.EnableUserResponse =
      zio.aws.finspacedata.model.EnableUserResponse(userId.map(value => value))
    def userId: Optional[UserId]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
  ) extends zio.aws.finspacedata.model.EnableUserResponse.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
  ): zio.aws.finspacedata.model.EnableUserResponse.ReadOnly = new Wrapper(impl)
}
