package zio.aws.finspacedata.model
import zio.prelude.data.Optional
import zio.aws.finspacedata.model.primitives.StatusCode
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DisassociateUserFromPermissionGroupResponse(
    statusCode: Optional[StatusCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DisassociateUserFromPermissionGroupResponse = {
    import DisassociateUserFromPermissionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DisassociateUserFromPermissionGroupResponse
      .builder()
      .optionallyWith(
        statusCode.map(value => StatusCode.unwrap(value): Integer)
      )(_.statusCode)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse.ReadOnly =
    zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse
      .wrap(buildAwsValue())
}
object DisassociateUserFromPermissionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DisassociateUserFromPermissionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse =
      zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse(
        statusCode.map(value => value)
      )
    def statusCode: Optional[StatusCode]
    def getStatusCode: ZIO[Any, AwsError, StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DisassociateUserFromPermissionGroupResponse
  ) extends zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse.ReadOnly {
    override val statusCode: Optional[StatusCode] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => zio.aws.finspacedata.model.primitives.StatusCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DisassociateUserFromPermissionGroupResponse
  ): zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse.ReadOnly =
    new Wrapper(impl)
}
