package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.DatasetId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDatasetResponse(
    datasetId: Optional[DatasetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse = {
    import DeleteDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly =
    zio.aws.finspacedata.model.DeleteDatasetResponse.wrap(buildAwsValue())
}
object DeleteDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DeleteDatasetResponse =
      zio.aws.finspacedata.model
        .DeleteDatasetResponse(datasetId.map(value => value))
    def datasetId: Optional[DatasetId]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
  ) extends zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly {
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
  ): zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
