package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.ErrorMessage
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataViewErrorInfo(
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    errorCategory: Optional[zio.aws.finspacedata.model.ErrorCategory] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DataViewErrorInfo = {
    import DataViewErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DataViewErrorInfo
      .builder()
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(errorCategory.map(value => value.unwrap))(_.errorCategory)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly =
    zio.aws.finspacedata.model.DataViewErrorInfo.wrap(buildAwsValue())
}
object DataViewErrorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DataViewErrorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DataViewErrorInfo =
      zio.aws.finspacedata.model.DataViewErrorInfo(
        errorMessage.map(value => value),
        errorCategory.map(value => value)
      )
    def errorMessage: Optional[ErrorMessage]
    def errorCategory: Optional[zio.aws.finspacedata.model.ErrorCategory]
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCategory
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.ErrorCategory] =
      AwsError.unwrapOptionField("errorCategory", errorCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewErrorInfo
  ) extends zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly {
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.finspacedata.model.primitives.ErrorMessage(value))
    override val errorCategory
        : Optional[zio.aws.finspacedata.model.ErrorCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCategory())
        .map(value => zio.aws.finspacedata.model.ErrorCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewErrorInfo
  ): zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly = new Wrapper(impl)
}
