package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  AliasString,
  DatasetDescription,
  DatasetTitle,
  ClientToken
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    datasetTitle: DatasetTitle,
    kind: zio.aws.finspacedata.model.DatasetKind,
    datasetDescription: Optional[DatasetDescription] = Optional.Absent,
    ownerInfo: Optional[zio.aws.finspacedata.model.DatasetOwnerInfo] =
      Optional.Absent,
    permissionGroupParams: zio.aws.finspacedata.model.PermissionGroupParams,
    alias: Optional[AliasString] = Optional.Absent,
    schemaDefinition: Optional[zio.aws.finspacedata.model.SchemaUnion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .datasetTitle(DatasetTitle.unwrap(datasetTitle): java.lang.String)
      .kind(kind.unwrap)
      .optionallyWith(
        datasetDescription.map(value =>
          DatasetDescription.unwrap(value): java.lang.String
        )
      )(_.datasetDescription)
      .optionallyWith(ownerInfo.map(value => value.buildAwsValue()))(
        _.ownerInfo
      )
      .permissionGroupParams(permissionGroupParams.buildAwsValue())
      .optionallyWith(
        alias.map(value => AliasString.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(schemaDefinition.map(value => value.buildAwsValue()))(
        _.schemaDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.CreateDatasetRequest.ReadOnly =
    zio.aws.finspacedata.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreateDatasetRequest =
      zio.aws.finspacedata.model.CreateDatasetRequest(
        clientToken.map(value => value),
        datasetTitle,
        kind,
        datasetDescription.map(value => value),
        ownerInfo.map(value => value.asEditable),
        permissionGroupParams.asEditable,
        alias.map(value => value),
        schemaDefinition.map(value => value.asEditable)
      )
    def clientToken: Optional[ClientToken]
    def datasetTitle: DatasetTitle
    def kind: zio.aws.finspacedata.model.DatasetKind
    def datasetDescription: Optional[DatasetDescription]
    def ownerInfo
        : Optional[zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly]
    def permissionGroupParams
        : zio.aws.finspacedata.model.PermissionGroupParams.ReadOnly
    def alias: Optional[AliasString]
    def schemaDefinition
        : Optional[zio.aws.finspacedata.model.SchemaUnion.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatasetTitle: ZIO[Any, Nothing, DatasetTitle] =
      ZIO.succeed(datasetTitle)
    def getKind: ZIO[Any, Nothing, zio.aws.finspacedata.model.DatasetKind] =
      ZIO.succeed(kind)
    def getDatasetDescription: ZIO[Any, AwsError, DatasetDescription] =
      AwsError.unwrapOptionField("datasetDescription", datasetDescription)
    def getOwnerInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly
    ] = AwsError.unwrapOptionField("ownerInfo", ownerInfo)
    def getPermissionGroupParams: ZIO[
      Any,
      Nothing,
      zio.aws.finspacedata.model.PermissionGroupParams.ReadOnly
    ] = ZIO.succeed(permissionGroupParams)
    def getAlias: ZIO[Any, AwsError, AliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getSchemaDefinition
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      AwsError.unwrapOptionField("schemaDefinition", schemaDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest
  ) extends zio.aws.finspacedata.model.CreateDatasetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
    override val datasetTitle: DatasetTitle =
      zio.aws.finspacedata.model.primitives.DatasetTitle(impl.datasetTitle())
    override val kind: zio.aws.finspacedata.model.DatasetKind =
      zio.aws.finspacedata.model.DatasetKind.wrap(impl.kind())
    override val datasetDescription: Optional[DatasetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetDescription())
        .map(value =>
          zio.aws.finspacedata.model.primitives.DatasetDescription(value)
        )
    override val ownerInfo
        : Optional[zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerInfo())
        .map(value => zio.aws.finspacedata.model.DatasetOwnerInfo.wrap(value))
    override val permissionGroupParams
        : zio.aws.finspacedata.model.PermissionGroupParams.ReadOnly =
      zio.aws.finspacedata.model.PermissionGroupParams
        .wrap(impl.permissionGroupParams())
    override val alias: Optional[AliasString] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.finspacedata.model.primitives.AliasString(value))
    override val schemaDefinition
        : Optional[zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaDefinition())
        .map(value => zio.aws.finspacedata.model.SchemaUnion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest
  ): zio.aws.finspacedata.model.CreateDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
