package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{ChangesetId, DatasetId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateChangesetResponse(
    datasetId: Optional[DatasetId] = Optional.Absent,
    changesetId: Optional[ChangesetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse = {
    import CreateChangesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly =
    zio.aws.finspacedata.model.CreateChangesetResponse.wrap(buildAwsValue())
}
object CreateChangesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreateChangesetResponse =
      zio.aws.finspacedata.model.CreateChangesetResponse(
        datasetId.map(value => value),
        changesetId.map(value => value)
      )
    def datasetId: Optional[DatasetId]
    def changesetId: Optional[ChangesetId]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse
  ) extends zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly {
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val changesetId: Optional[ChangesetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changesetId())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse
  ): zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly = new Wrapper(
    impl
  )
}
