package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  ClientToken,
  UserId,
  PermissionGroupId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateUserToPermissionGroupRequest(
    permissionGroupId: PermissionGroupId,
    userId: UserId,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.AssociateUserToPermissionGroupRequest = {
    import AssociateUserToPermissionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.AssociateUserToPermissionGroupRequest
      .builder()
      .permissionGroupId(
        PermissionGroupId.unwrap(permissionGroupId): java.lang.String
      )
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.AssociateUserToPermissionGroupRequest.ReadOnly =
    zio.aws.finspacedata.model.AssociateUserToPermissionGroupRequest
      .wrap(buildAwsValue())
}
object AssociateUserToPermissionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.AssociateUserToPermissionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.AssociateUserToPermissionGroupRequest =
      zio.aws.finspacedata.model.AssociateUserToPermissionGroupRequest(
        permissionGroupId,
        userId,
        clientToken.map(value => value)
      )
    def permissionGroupId: PermissionGroupId
    def userId: UserId
    def clientToken: Optional[ClientToken]
    def getPermissionGroupId: ZIO[Any, Nothing, PermissionGroupId] =
      ZIO.succeed(permissionGroupId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.AssociateUserToPermissionGroupRequest
  ) extends zio.aws.finspacedata.model.AssociateUserToPermissionGroupRequest.ReadOnly {
    override val permissionGroupId: PermissionGroupId =
      zio.aws.finspacedata.model.primitives
        .PermissionGroupId(impl.permissionGroupId())
    override val userId: UserId =
      zio.aws.finspacedata.model.primitives.UserId(impl.userId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.AssociateUserToPermissionGroupRequest
  ): zio.aws.finspacedata.model.AssociateUserToPermissionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
