package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait UserType {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.UserType
}
object UserType {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.UserType
  ): zio.aws.finspacedata.model.UserType = value match {
    case software.amazon.awssdk.services.finspacedata.model.UserType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.UserType.SUPER_USER =>
      val r = SUPER_USER
      r
    case software.amazon.awssdk.services.finspacedata.model.UserType.APP_USER =>
      val r = APP_USER
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspacedata.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.UserType =
      software.amazon.awssdk.services.finspacedata.model.UserType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUPER_USER extends zio.aws.finspacedata.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.UserType =
      software.amazon.awssdk.services.finspacedata.model.UserType.SUPER_USER
  }
  case object APP_USER extends zio.aws.finspacedata.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.UserType =
      software.amazon.awssdk.services.finspacedata.model.UserType.APP_USER
  }
}
