package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.UserId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateUserResponse(
    userId: Optional[UserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse = {
    import UpdateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly =
    zio.aws.finspacedata.model.UpdateUserResponse.wrap(buildAwsValue())
}
object UpdateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateUserResponse =
      zio.aws.finspacedata.model.UpdateUserResponse(userId.map(value => value))
    def userId: Optional[UserId]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
  ) extends zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
  ): zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly = new Wrapper(impl)
}
