package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{DatasetId, ChangesetId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateChangesetResponse(
    changesetId: Optional[ChangesetId] = Optional.Absent,
    datasetId: Optional[DatasetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse = {
    import UpdateChangesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
      .builder()
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly =
    zio.aws.finspacedata.model.UpdateChangesetResponse.wrap(buildAwsValue())
}
object UpdateChangesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateChangesetResponse =
      zio.aws.finspacedata.model.UpdateChangesetResponse(
        changesetId.map(value => value),
        datasetId.map(value => value)
      )
    def changesetId: Optional[ChangesetId]
    def datasetId: Optional[DatasetId]
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
  ) extends zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly {
    override val changesetId: Optional[ChangesetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changesetId())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
  ): zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly = new Wrapper(
    impl
  )
}
