package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PermissionGroupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PermissionGroupParams(
    permissionGroupId: Optional[PermissionGroupId] = Optional.Absent,
    datasetPermissions: Optional[
      Iterable[zio.aws.finspacedata.model.ResourcePermission]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.PermissionGroupParams = {
    import PermissionGroupParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.PermissionGroupParams
      .builder()
      .optionallyWith(
        permissionGroupId.map(value =>
          PermissionGroupId.unwrap(value): java.lang.String
        )
      )(_.permissionGroupId)
      .optionallyWith(
        datasetPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetPermissions)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.PermissionGroupParams.ReadOnly =
    zio.aws.finspacedata.model.PermissionGroupParams.wrap(buildAwsValue())
}
object PermissionGroupParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.PermissionGroupParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.PermissionGroupParams =
      zio.aws.finspacedata.model.PermissionGroupParams(
        permissionGroupId.map(value => value),
        datasetPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def permissionGroupId: Optional[PermissionGroupId]
    def datasetPermissions
        : Optional[List[zio.aws.finspacedata.model.ResourcePermission.ReadOnly]]
    def getPermissionGroupId: ZIO[Any, AwsError, PermissionGroupId] =
      AwsError.unwrapOptionField("permissionGroupId", permissionGroupId)
    def getDatasetPermissions: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.ResourcePermission.ReadOnly
    ]] = AwsError.unwrapOptionField("datasetPermissions", datasetPermissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroupParams
  ) extends zio.aws.finspacedata.model.PermissionGroupParams.ReadOnly {
    override val permissionGroupId: Optional[PermissionGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionGroupId())
        .map(value =>
          zio.aws.finspacedata.model.primitives.PermissionGroupId(value)
        )
    override val datasetPermissions: Optional[
      List[zio.aws.finspacedata.model.ResourcePermission.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.ResourcePermission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroupParams
  ): zio.aws.finspacedata.model.PermissionGroupParams.ReadOnly = new Wrapper(
    impl
  )
}
