package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  PermissionGroupName,
  PermissionGroupId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PermissionGroupByUser(
    permissionGroupId: Optional[PermissionGroupId] = Optional.Absent,
    name: Optional[PermissionGroupName] = Optional.Absent,
    membershipStatus: Optional[
      zio.aws.finspacedata.model.PermissionGroupMembershipStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.PermissionGroupByUser = {
    import PermissionGroupByUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.PermissionGroupByUser
      .builder()
      .optionallyWith(
        permissionGroupId.map(value =>
          PermissionGroupId.unwrap(value): java.lang.String
        )
      )(_.permissionGroupId)
      .optionallyWith(
        name.map(value => PermissionGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(membershipStatus.map(value => value.unwrap))(
        _.membershipStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.PermissionGroupByUser.ReadOnly =
    zio.aws.finspacedata.model.PermissionGroupByUser.wrap(buildAwsValue())
}
object PermissionGroupByUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.PermissionGroupByUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.PermissionGroupByUser =
      zio.aws.finspacedata.model.PermissionGroupByUser(
        permissionGroupId.map(value => value),
        name.map(value => value),
        membershipStatus.map(value => value)
      )
    def permissionGroupId: Optional[PermissionGroupId]
    def name: Optional[PermissionGroupName]
    def membershipStatus
        : Optional[zio.aws.finspacedata.model.PermissionGroupMembershipStatus]
    def getPermissionGroupId: ZIO[Any, AwsError, PermissionGroupId] =
      AwsError.unwrapOptionField("permissionGroupId", permissionGroupId)
    def getName: ZIO[Any, AwsError, PermissionGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getMembershipStatus: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.PermissionGroupMembershipStatus
    ] = AwsError.unwrapOptionField("membershipStatus", membershipStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroupByUser
  ) extends zio.aws.finspacedata.model.PermissionGroupByUser.ReadOnly {
    override val permissionGroupId: Optional[PermissionGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionGroupId())
        .map(value =>
          zio.aws.finspacedata.model.primitives.PermissionGroupId(value)
        )
    override val name: Optional[PermissionGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupName(value)
      )
    override val membershipStatus
        : Optional[zio.aws.finspacedata.model.PermissionGroupMembershipStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.membershipStatus())
        .map(value =>
          zio.aws.finspacedata.model.PermissionGroupMembershipStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroupByUser
  ): zio.aws.finspacedata.model.PermissionGroupByUser.ReadOnly = new Wrapper(
    impl
  )
}
