package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  TimestampEpoch,
  StringMapValue,
  ChangesetArn,
  ChangesetId,
  StringMapKey,
  DatasetId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ChangesetSummary(
    changesetId: Optional[ChangesetId] = Optional.Absent,
    changesetArn: Optional[ChangesetArn] = Optional.Absent,
    datasetId: Optional[DatasetId] = Optional.Absent,
    changeType: Optional[zio.aws.finspacedata.model.ChangeType] =
      Optional.Absent,
    sourceParams: Optional[Map[StringMapKey, StringMapValue]] = Optional.Absent,
    formatParams: Optional[Map[StringMapKey, StringMapValue]] = Optional.Absent,
    createTime: Optional[TimestampEpoch] = Optional.Absent,
    status: Optional[zio.aws.finspacedata.model.IngestionStatus] =
      Optional.Absent,
    errorInfo: Optional[zio.aws.finspacedata.model.ChangesetErrorInfo] =
      Optional.Absent,
    activeUntilTimestamp: Optional[TimestampEpoch] = Optional.Absent,
    activeFromTimestamp: Optional[TimestampEpoch] = Optional.Absent,
    updatesChangesetId: Optional[ChangesetId] = Optional.Absent,
    updatedByChangesetId: Optional[ChangesetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ChangesetSummary = {
    import ChangesetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ChangesetSummary
      .builder()
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .optionallyWith(
        changesetArn.map(value => ChangesetArn.unwrap(value): java.lang.String)
      )(_.changesetArn)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(changeType.map(value => value.unwrap))(_.changeType)
      .optionallyWith(
        sourceParams.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.sourceParams)
      .optionallyWith(
        formatParams.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.formatParams)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(
        activeUntilTimestamp.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.activeUntilTimestamp)
      .optionallyWith(
        activeFromTimestamp.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.activeFromTimestamp)
      .optionallyWith(
        updatesChangesetId.map(value =>
          ChangesetId.unwrap(value): java.lang.String
        )
      )(_.updatesChangesetId)
      .optionallyWith(
        updatedByChangesetId.map(value =>
          ChangesetId.unwrap(value): java.lang.String
        )
      )(_.updatedByChangesetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ChangesetSummary.ReadOnly =
    zio.aws.finspacedata.model.ChangesetSummary.wrap(buildAwsValue())
}
object ChangesetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ChangesetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ChangesetSummary =
      zio.aws.finspacedata.model.ChangesetSummary(
        changesetId.map(value => value),
        changesetArn.map(value => value),
        datasetId.map(value => value),
        changeType.map(value => value),
        sourceParams.map(value => value),
        formatParams.map(value => value),
        createTime.map(value => value),
        status.map(value => value),
        errorInfo.map(value => value.asEditable),
        activeUntilTimestamp.map(value => value),
        activeFromTimestamp.map(value => value),
        updatesChangesetId.map(value => value),
        updatedByChangesetId.map(value => value)
      )
    def changesetId: Optional[ChangesetId]
    def changesetArn: Optional[ChangesetArn]
    def datasetId: Optional[DatasetId]
    def changeType: Optional[zio.aws.finspacedata.model.ChangeType]
    def sourceParams: Optional[Map[StringMapKey, StringMapValue]]
    def formatParams: Optional[Map[StringMapKey, StringMapValue]]
    def createTime: Optional[TimestampEpoch]
    def status: Optional[zio.aws.finspacedata.model.IngestionStatus]
    def errorInfo
        : Optional[zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly]
    def activeUntilTimestamp: Optional[TimestampEpoch]
    def activeFromTimestamp: Optional[TimestampEpoch]
    def updatesChangesetId: Optional[ChangesetId]
    def updatedByChangesetId: Optional[ChangesetId]
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
    def getChangesetArn: ZIO[Any, AwsError, ChangesetArn] =
      AwsError.unwrapOptionField("changesetArn", changesetArn)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getChangeType
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.ChangeType] =
      AwsError.unwrapOptionField("changeType", changeType)
    def getSourceParams: ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("sourceParams", sourceParams)
    def getFormatParams: ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("formatParams", formatParams)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.IngestionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getActiveUntilTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("activeUntilTimestamp", activeUntilTimestamp)
    def getActiveFromTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("activeFromTimestamp", activeFromTimestamp)
    def getUpdatesChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("updatesChangesetId", updatesChangesetId)
    def getUpdatedByChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("updatedByChangesetId", updatedByChangesetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ChangesetSummary
  ) extends zio.aws.finspacedata.model.ChangesetSummary.ReadOnly {
    override val changesetId: Optional[ChangesetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changesetId())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
    override val changesetArn: Optional[ChangesetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.changesetArn())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetArn(value))
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val changeType: Optional[zio.aws.finspacedata.model.ChangeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeType())
        .map(value => zio.aws.finspacedata.model.ChangeType.wrap(value))
    override val sourceParams: Optional[Map[StringMapKey, StringMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceParams())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.finspacedata.model.primitives.StringMapKey(
                key
              ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
            })
            .toMap
        )
    override val formatParams: Optional[Map[StringMapKey, StringMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatParams())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.finspacedata.model.primitives.StringMapKey(
                key
              ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
            })
            .toMap
        )
    override val createTime: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val status: Optional[zio.aws.finspacedata.model.IngestionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspacedata.model.IngestionStatus.wrap(value))
    override val errorInfo
        : Optional[zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value => zio.aws.finspacedata.model.ChangesetErrorInfo.wrap(value))
    override val activeUntilTimestamp: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeUntilTimestamp())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val activeFromTimestamp: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeFromTimestamp())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val updatesChangesetId: Optional[ChangesetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatesChangesetId())
        .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
    override val updatedByChangesetId: Optional[ChangesetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedByChangesetId())
        .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ChangesetSummary
  ): zio.aws.finspacedata.model.ChangesetSummary.ReadOnly = new Wrapper(impl)
}
