package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  RoleArn,
  UserId,
  TimestampEpoch,
  Email,
  FirstName,
  LastName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class User(
    userId: Optional[UserId] = Optional.Absent,
    status: Optional[zio.aws.finspacedata.model.UserStatus] = Optional.Absent,
    firstName: Optional[FirstName] = Optional.Absent,
    lastName: Optional[LastName] = Optional.Absent,
    emailAddress: Optional[Email] = Optional.Absent,
    `type`: Optional[zio.aws.finspacedata.model.UserType] = Optional.Absent,
    apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess] = Optional.Absent,
    apiAccessPrincipalArn: Optional[RoleArn] = Optional.Absent,
    createTime: Optional[TimestampEpoch] = Optional.Absent,
    lastEnabledTime: Optional[TimestampEpoch] = Optional.Absent,
    lastDisabledTime: Optional[TimestampEpoch] = Optional.Absent,
    lastModifiedTime: Optional[TimestampEpoch] = Optional.Absent,
    lastLoginTime: Optional[TimestampEpoch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.User
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        firstName.map(value => FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(apiAccess.map(value => value.unwrap))(_.apiAccess)
      .optionallyWith(
        apiAccessPrincipalArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.apiAccessPrincipalArn)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastEnabledTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastEnabledTime)
      .optionallyWith(
        lastDisabledTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastDisabledTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .optionallyWith(
        lastLoginTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.lastLoginTime)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.User.ReadOnly =
    zio.aws.finspacedata.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.finspacedata.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.User =
      zio.aws.finspacedata.model.User(
        userId.map(value => value),
        status.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        emailAddress.map(value => value),
        `type`.map(value => value),
        apiAccess.map(value => value),
        apiAccessPrincipalArn.map(value => value),
        createTime.map(value => value),
        lastEnabledTime.map(value => value),
        lastDisabledTime.map(value => value),
        lastModifiedTime.map(value => value),
        lastLoginTime.map(value => value)
      )
    def userId: Optional[UserId]
    def status: Optional[zio.aws.finspacedata.model.UserStatus]
    def firstName: Optional[FirstName]
    def lastName: Optional[LastName]
    def emailAddress: Optional[Email]
    def `type`: Optional[zio.aws.finspacedata.model.UserType]
    def apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess]
    def apiAccessPrincipalArn: Optional[RoleArn]
    def createTime: Optional[TimestampEpoch]
    def lastEnabledTime: Optional[TimestampEpoch]
    def lastDisabledTime: Optional[TimestampEpoch]
    def lastModifiedTime: Optional[TimestampEpoch]
    def lastLoginTime: Optional[TimestampEpoch]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getStatus: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFirstName: ZIO[Any, AwsError, FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getType: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getApiAccess: ZIO[Any, AwsError, zio.aws.finspacedata.model.ApiAccess] =
      AwsError.unwrapOptionField("apiAccess", apiAccess)
    def getApiAccessPrincipalArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("apiAccessPrincipalArn", apiAccessPrincipalArn)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastEnabledTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastEnabledTime", lastEnabledTime)
    def getLastDisabledTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastDisabledTime", lastDisabledTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastLoginTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastLoginTime", lastLoginTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.User
  ) extends zio.aws.finspacedata.model.User.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
    override val status: Optional[zio.aws.finspacedata.model.UserStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspacedata.model.UserStatus.wrap(value))
    override val firstName: Optional[FirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value => zio.aws.finspacedata.model.primitives.FirstName(value))
    override val lastName: Optional[LastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value => zio.aws.finspacedata.model.primitives.LastName(value))
    override val emailAddress: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.finspacedata.model.primitives.Email(value))
    override val `type`: Optional[zio.aws.finspacedata.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.finspacedata.model.UserType.wrap(value))
    override val apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAccess())
        .map(value => zio.aws.finspacedata.model.ApiAccess.wrap(value))
    override val apiAccessPrincipalArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAccessPrincipalArn())
        .map(value => zio.aws.finspacedata.model.primitives.RoleArn(value))
    override val createTime: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastEnabledTime: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEnabledTime())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val lastDisabledTime: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDisabledTime())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val lastModifiedTime: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val lastLoginTime: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.lastLoginTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.User
  ): zio.aws.finspacedata.model.User.ReadOnly = new Wrapper(impl)
}
