package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.finspacedata.model.primitives.UserId
import scala.jdk.CollectionConverters.*
final case class GetUserRequest(userId: UserId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetUserRequest = {
    import GetUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetUserRequest.ReadOnly =
    zio.aws.finspacedata.model.GetUserRequest.wrap(buildAwsValue())
}
object GetUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetUserRequest =
      zio.aws.finspacedata.model.GetUserRequest(userId)
    def userId: UserId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetUserRequest
  ) extends zio.aws.finspacedata.model.GetUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.finspacedata.model.primitives.UserId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetUserRequest
  ): zio.aws.finspacedata.model.GetUserRequest.ReadOnly = new Wrapper(impl)
}
