package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.finspacedata.model.primitives.StringValueLength1to255
import scala.jdk.CollectionConverters.*
final case class GetDatasetRequest(datasetId: StringValueLength1to255) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest = {
    import GetDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest
      .builder()
      .datasetId(StringValueLength1to255.unwrap(datasetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetDatasetRequest.ReadOnly =
    zio.aws.finspacedata.model.GetDatasetRequest.wrap(buildAwsValue())
}
object GetDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetDatasetRequest =
      zio.aws.finspacedata.model.GetDatasetRequest(datasetId)
    def datasetId: StringValueLength1to255
    def getDatasetId: ZIO[Any, Nothing, StringValueLength1to255] =
      ZIO.succeed(datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest
  ) extends zio.aws.finspacedata.model.GetDatasetRequest.ReadOnly {
    override val datasetId: StringValueLength1to255 =
      zio.aws.finspacedata.model.primitives
        .StringValueLength1to255(impl.datasetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest
  ): zio.aws.finspacedata.model.GetDatasetRequest.ReadOnly = new Wrapper(impl)
}
