package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{DataViewId, DatasetId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataViewResponse(
    datasetId: Optional[DatasetId] = Optional.Absent,
    dataViewId: Optional[DataViewId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreateDataViewResponse = {
    import CreateDataViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreateDataViewResponse
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        dataViewId.map(value => DataViewId.unwrap(value): java.lang.String)
      )(_.dataViewId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly =
    zio.aws.finspacedata.model.CreateDataViewResponse.wrap(buildAwsValue())
}
object CreateDataViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreateDataViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreateDataViewResponse =
      zio.aws.finspacedata.model.CreateDataViewResponse(
        datasetId.map(value => value),
        dataViewId.map(value => value)
      )
    def datasetId: Optional[DatasetId]
    def dataViewId: Optional[DataViewId]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getDataViewId: ZIO[Any, AwsError, DataViewId] =
      AwsError.unwrapOptionField("dataViewId", dataViewId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDataViewResponse
  ) extends zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly {
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val dataViewId: Optional[DataViewId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataViewId())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDataViewResponse
  ): zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly = new Wrapper(
    impl
  )
}
