package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait ChangeType {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.ChangeType
}
object ChangeType {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.ChangeType
  ): zio.aws.finspacedata.model.ChangeType = value match {
    case software.amazon.awssdk.services.finspacedata.model.ChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.ChangeType.REPLACE =>
      val r = REPLACE
      r
    case software.amazon.awssdk.services.finspacedata.model.ChangeType.APPEND =>
      val r = APPEND
      r
    case software.amazon.awssdk.services.finspacedata.model.ChangeType.MODIFY =>
      val r = MODIFY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ChangeType =
      software.amazon.awssdk.services.finspacedata.model.ChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object REPLACE extends zio.aws.finspacedata.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ChangeType =
      software.amazon.awssdk.services.finspacedata.model.ChangeType.REPLACE
  }
  case object APPEND extends zio.aws.finspacedata.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ChangeType =
      software.amazon.awssdk.services.finspacedata.model.ChangeType.APPEND
  }
  case object MODIFY extends zio.aws.finspacedata.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ChangeType =
      software.amazon.awssdk.services.finspacedata.model.ChangeType.MODIFY
  }
}
