package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.ColumnName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SchemaDefinition(
    columns: Optional[Iterable[zio.aws.finspacedata.model.ColumnDefinition]] =
      Optional.Absent,
    primaryKeyColumns: Optional[Iterable[ColumnName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.SchemaDefinition = {
    import SchemaDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.SchemaDefinition
      .builder()
      .optionallyWith(
        columns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columns)
      .optionallyWith(
        primaryKeyColumns.map(value =>
          value.map { item =>
            ColumnName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.primaryKeyColumns)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.SchemaDefinition.ReadOnly =
    zio.aws.finspacedata.model.SchemaDefinition.wrap(buildAwsValue())
}
object SchemaDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.SchemaDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.SchemaDefinition =
      zio.aws.finspacedata.model.SchemaDefinition(
        columns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        primaryKeyColumns.map(value => value)
      )
    def columns
        : Optional[List[zio.aws.finspacedata.model.ColumnDefinition.ReadOnly]]
    def primaryKeyColumns: Optional[List[ColumnName]]
    def getColumns: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.ColumnDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("columns", columns)
    def getPrimaryKeyColumns: ZIO[Any, AwsError, List[ColumnName]] =
      AwsError.unwrapOptionField("primaryKeyColumns", primaryKeyColumns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.SchemaDefinition
  ) extends zio.aws.finspacedata.model.SchemaDefinition.ReadOnly {
    override val columns
        : Optional[List[zio.aws.finspacedata.model.ColumnDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.ColumnDefinition.wrap(item)
          }.toList
        )
    override val primaryKeyColumns: Optional[List[ColumnName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryKeyColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.primitives.ColumnName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.SchemaDefinition
  ): zio.aws.finspacedata.model.SchemaDefinition.ReadOnly = new Wrapper(impl)
}
