package zio.aws.finspacedata
import zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.finspacedata.model.{
  ListChangesetsRequest,
  ListPermissionGroupsRequest,
  CreateDatasetRequest,
  DeletePermissionGroupRequest,
  EnableUserRequest,
  GetProgrammaticAccessCredentialsRequest,
  ListUsersRequest,
  CreateChangesetRequest,
  CreatePermissionGroupRequest,
  ListDatasetsRequest,
  CreateUserRequest,
  GetChangesetRequest,
  DeleteDatasetRequest,
  GetUserRequest,
  ListDataViewsRequest,
  UpdatePermissionGroupRequest,
  CreateDataViewRequest,
  GetDatasetRequest,
  ResetUserPasswordRequest,
  UpdateChangesetRequest,
  UpdateUserRequest,
  GetWorkingLocationRequest,
  UpdateDatasetRequest,
  GetDataViewRequest,
  DisableUserRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.finspacedata.paginators.{
  ListChangesetsPublisher,
  ListPermissionGroupsPublisher,
  ListDatasetsPublisher,
  ListUsersPublisher,
  ListDataViewsPublisher
}
import software.amazon.awssdk.services.finspacedata.model.{
  UpdatePermissionGroupResponse,
  GetProgrammaticAccessCredentialsResponse,
  ListUsersResponse,
  PermissionGroup,
  User,
  UpdateChangesetResponse,
  GetWorkingLocationResponse,
  DeletePermissionGroupResponse,
  ListPermissionGroupsResponse,
  GetUserResponse,
  GetChangesetResponse,
  CreateDatasetResponse,
  EnableUserResponse,
  ListChangesetsResponse,
  CreateDataViewResponse,
  ListDataViewsResponse,
  ResetUserPasswordResponse,
  GetDatasetResponse,
  CreatePermissionGroupResponse,
  CreateUserResponse,
  DataViewSummary,
  CreateChangesetResponse,
  DeleteDatasetResponse,
  Dataset,
  ListDatasetsResponse,
  ChangesetSummary,
  DisableUserResponse,
  UpdateUserResponse,
  UpdateDatasetResponse,
  GetDataViewResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.finspacedata.{
  FinspaceDataAsyncClientBuilder,
  FinspaceDataAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait FinspaceData extends AspectSupport[FinspaceData] {
  val api: FinspaceDataAsyncClient
  def createDataset(
      request: CreateDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly]
  def listDataViews(
      request: ListDataViewsRequest
  ): ZStream[Any, AwsError, zio.aws.finspacedata.model.DataViewSummary.ReadOnly]
  def listDataViewsPaginated(
      request: ListDataViewsRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly]
  def listUsers(
      request: ListUsersRequest
  ): ZStream[Any, AwsError, zio.aws.finspacedata.model.User.ReadOnly]
  def listUsersPaginated(
      request: ListUsersRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ListUsersResponse.ReadOnly]
  def updateUser(
      request: UpdateUserRequest
  ): IO[AwsError, zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly]
  def createPermissionGroup(request: CreatePermissionGroupRequest): IO[
    AwsError,
    zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly
  ]
  def listPermissionGroups(
      request: ListPermissionGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.finspacedata.model.PermissionGroup.ReadOnly]
  def listPermissionGroupsPaginated(request: ListPermissionGroupsRequest): IO[
    AwsError,
    zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly
  ]
  def updatePermissionGroup(request: UpdatePermissionGroupRequest): IO[
    AwsError,
    zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly
  ]
  def deletePermissionGroup(request: DeletePermissionGroupRequest): IO[
    AwsError,
    zio.aws.finspacedata.model.DeletePermissionGroupResponse.ReadOnly
  ]
  def getUser(
      request: GetUserRequest
  ): IO[AwsError, zio.aws.finspacedata.model.GetUserResponse.ReadOnly]
  def createUser(
      request: CreateUserRequest
  ): IO[AwsError, zio.aws.finspacedata.model.CreateUserResponse.ReadOnly]
  def updateDataset(
      request: UpdateDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly]
  def disableUser(
      request: DisableUserRequest
  ): IO[AwsError, zio.aws.finspacedata.model.DisableUserResponse.ReadOnly]
  def createChangeset(
      request: CreateChangesetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly]
  def getChangeset(
      request: GetChangesetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly]
  def updateChangeset(
      request: UpdateChangesetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly]
  def listDatasets(
      request: ListDatasetsRequest
  ): ZStream[Any, AwsError, zio.aws.finspacedata.model.Dataset.ReadOnly]
  def listDatasetsPaginated(
      request: ListDatasetsRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly]
  def getDataset(
      request: GetDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly]
  def getDataView(
      request: GetDataViewRequest
  ): IO[AwsError, zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly]
  def enableUser(
      request: EnableUserRequest
  ): IO[AwsError, zio.aws.finspacedata.model.EnableUserResponse.ReadOnly]
  def resetUserPassword(
      request: ResetUserPasswordRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly]
  def listChangesets(request: ListChangesetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
  ]
  def listChangesetsPaginated(
      request: ListChangesetsRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly]
  def getProgrammaticAccessCredentials(
      request: GetProgrammaticAccessCredentialsRequest
  ): IO[AwsError, ReadOnly]
  def deleteDataset(
      request: DeleteDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly]
  def getWorkingLocation(request: GetWorkingLocationRequest): IO[
    AwsError,
    zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
  ]
  def createDataView(
      request: CreateDataViewRequest
  ): IO[AwsError, zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly]
}
object FinspaceData {
  val live: ZLayer[AwsConfig, java.lang.Throwable, FinspaceData] = customized(
    identity
  )
  def customized(
      customization: FinspaceDataAsyncClientBuilder => FinspaceDataAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, FinspaceData] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: FinspaceDataAsyncClientBuilder => FinspaceDataAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, FinspaceData] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = FinspaceDataAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[FinspaceDataAsyncClient, FinspaceDataAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      FinspaceDataAsyncClient,
      FinspaceDataAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new FinspaceDataImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class FinspaceDataImpl[R](
      override val api: FinspaceDataAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends FinspaceData
      with AwsServiceBase[R] {
    override val serviceName: String = "FinspaceData"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): FinspaceDataImpl[R1] = new FinspaceDataImpl(api, newAspect, r)
    def createDataset(
        request: CreateDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest,
        CreateDatasetResponse
      ]("createDataset", api.createDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.CreateDatasetResponse.wrap)
        .provideEnvironment(r)
    def listDataViews(request: ListDataViewsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest,
      DataViewSummary,
      ListDataViewsPublisher
    ]("listDataViews", api.listDataViewsPaginator, _.dataViews())(
      request.buildAwsValue()
    ).map(item => zio.aws.finspacedata.model.DataViewSummary.wrap(item))
      .provideEnvironment(r)
    def listDataViewsPaginated(
        request: ListDataViewsRequest
    ): IO[AwsError, zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest,
        ListDataViewsResponse
      ]("listDataViews", api.listDataViews)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.ListDataViewsResponse.wrap)
        .provideEnvironment(r)
    def listUsers(
        request: ListUsersRequest
    ): ZStream[Any, AwsError, zio.aws.finspacedata.model.User.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.finspacedata.model.ListUsersRequest,
        User,
        ListUsersPublisher
      ]("listUsers", api.listUsersPaginator, _.users())(request.buildAwsValue())
        .map(item => zio.aws.finspacedata.model.User.wrap(item))
        .provideEnvironment(r)
    def listUsersPaginated(
        request: ListUsersRequest
    ): IO[AwsError, zio.aws.finspacedata.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.ListUsersRequest,
        ListUsersResponse
      ]("listUsers", api.listUsers)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
    def updateUser(
        request: UpdateUserRequest
    ): IO[AwsError, zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest,
        UpdateUserResponse
      ]("updateUser", api.updateUser)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.UpdateUserResponse.wrap)
        .provideEnvironment(r)
    def createPermissionGroup(request: CreatePermissionGroupRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupRequest,
      CreatePermissionGroupResponse
    ]("createPermissionGroup", api.createPermissionGroup)(
      request.buildAwsValue()
    ).map(zio.aws.finspacedata.model.CreatePermissionGroupResponse.wrap)
      .provideEnvironment(r)
    def listPermissionGroups(request: ListPermissionGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.finspacedata.model.PermissionGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest,
      PermissionGroup,
      ListPermissionGroupsPublisher
    ](
      "listPermissionGroups",
      api.listPermissionGroupsPaginator,
      _.permissionGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.finspacedata.model.PermissionGroup.wrap(item))
      .provideEnvironment(r)
    def listPermissionGroupsPaginated(request: ListPermissionGroupsRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest,
      ListPermissionGroupsResponse
    ]("listPermissionGroups", api.listPermissionGroups)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.ListPermissionGroupsResponse.wrap)
      .provideEnvironment(r)
    def updatePermissionGroup(request: UpdatePermissionGroupRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupRequest,
      UpdatePermissionGroupResponse
    ]("updatePermissionGroup", api.updatePermissionGroup)(
      request.buildAwsValue()
    ).map(zio.aws.finspacedata.model.UpdatePermissionGroupResponse.wrap)
      .provideEnvironment(r)
    def deletePermissionGroup(request: DeletePermissionGroupRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.DeletePermissionGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.DeletePermissionGroupRequest,
      DeletePermissionGroupResponse
    ]("deletePermissionGroup", api.deletePermissionGroup)(
      request.buildAwsValue()
    ).map(zio.aws.finspacedata.model.DeletePermissionGroupResponse.wrap)
      .provideEnvironment(r)
    def getUser(
        request: GetUserRequest
    ): IO[AwsError, zio.aws.finspacedata.model.GetUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.GetUserRequest,
        GetUserResponse
      ]("getUser", api.getUser)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.GetUserResponse.wrap)
        .provideEnvironment(r)
    def createUser(
        request: CreateUserRequest
    ): IO[AwsError, zio.aws.finspacedata.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.CreateUserRequest,
        CreateUserResponse
      ]("createUser", api.createUser)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def updateDataset(
        request: UpdateDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest,
        UpdateDatasetResponse
      ]("updateDataset", api.updateDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.UpdateDatasetResponse.wrap)
        .provideEnvironment(r)
    def disableUser(
        request: DisableUserRequest
    ): IO[AwsError, zio.aws.finspacedata.model.DisableUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.DisableUserRequest,
        DisableUserResponse
      ]("disableUser", api.disableUser)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.DisableUserResponse.wrap)
        .provideEnvironment(r)
    def createChangeset(request: CreateChangesetRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest,
      CreateChangesetResponse
    ]("createChangeset", api.createChangeset)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.CreateChangesetResponse.wrap)
      .provideEnvironment(r)
    def getChangeset(
        request: GetChangesetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest,
        GetChangesetResponse
      ]("getChangeset", api.getChangeset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.GetChangesetResponse.wrap)
        .provideEnvironment(r)
    def updateChangeset(request: UpdateChangesetRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest,
      UpdateChangesetResponse
    ]("updateChangeset", api.updateChangeset)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.UpdateChangesetResponse.wrap)
      .provideEnvironment(r)
    def listDatasets(
        request: ListDatasetsRequest
    ): ZStream[Any, AwsError, zio.aws.finspacedata.model.Dataset.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest,
        Dataset,
        ListDatasetsPublisher
      ]("listDatasets", api.listDatasetsPaginator, _.datasets())(
        request.buildAwsValue()
      ).map(item => zio.aws.finspacedata.model.Dataset.wrap(item))
        .provideEnvironment(r)
    def listDatasetsPaginated(
        request: ListDatasetsRequest
    ): IO[AwsError, zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest,
        ListDatasetsResponse
      ]("listDatasets", api.listDatasets)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.ListDatasetsResponse.wrap)
        .provideEnvironment(r)
    def getDataset(
        request: GetDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest,
        GetDatasetResponse
      ]("getDataset", api.getDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.GetDatasetResponse.wrap)
        .provideEnvironment(r)
    def getDataView(
        request: GetDataViewRequest
    ): IO[AwsError, zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest,
        GetDataViewResponse
      ]("getDataView", api.getDataView)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.GetDataViewResponse.wrap)
        .provideEnvironment(r)
    def enableUser(
        request: EnableUserRequest
    ): IO[AwsError, zio.aws.finspacedata.model.EnableUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.EnableUserRequest,
        EnableUserResponse
      ]("enableUser", api.enableUser)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.EnableUserResponse.wrap)
        .provideEnvironment(r)
    def resetUserPassword(request: ResetUserPasswordRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordRequest,
      ResetUserPasswordResponse
    ]("resetUserPassword", api.resetUserPassword)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.ResetUserPasswordResponse.wrap)
      .provideEnvironment(r)
    def listChangesets(request: ListChangesetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest,
      ChangesetSummary,
      ListChangesetsPublisher
    ]("listChangesets", api.listChangesetsPaginator, _.changesets())(
      request.buildAwsValue()
    ).map(item => zio.aws.finspacedata.model.ChangesetSummary.wrap(item))
      .provideEnvironment(r)
    def listChangesetsPaginated(request: ListChangesetsRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest,
      ListChangesetsResponse
    ]("listChangesets", api.listChangesets)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.ListChangesetsResponse.wrap)
      .provideEnvironment(r)
    def getProgrammaticAccessCredentials(
        request: GetProgrammaticAccessCredentialsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest,
      GetProgrammaticAccessCredentialsResponse
    ]("getProgrammaticAccessCredentials", api.getProgrammaticAccessCredentials)(
      request.buildAwsValue()
    ).map(
      zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.wrap
    ).provideEnvironment(r)
    def deleteDataset(
        request: DeleteDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest,
        DeleteDatasetResponse
      ]("deleteDataset", api.deleteDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.DeleteDatasetResponse.wrap)
        .provideEnvironment(r)
    def getWorkingLocation(request: GetWorkingLocationRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest,
      GetWorkingLocationResponse
    ]("getWorkingLocation", api.getWorkingLocation)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.GetWorkingLocationResponse.wrap)
      .provideEnvironment(r)
    def createDataView(request: CreateDataViewRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest,
      CreateDataViewResponse
    ]("createDataView", api.createDataView)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.CreateDataViewResponse.wrap)
      .provideEnvironment(r)
  }
  def createDataset(request: CreateDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def listDataViews(request: ListDataViewsRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.DataViewSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataViews(request))
  def listDataViewsPaginated(request: ListDataViewsRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataViewsPaginated(request))
  def listUsers(request: ListUsersRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.User.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsers(request))
  def listUsersPaginated(request: ListUsersRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def updateUser(request: UpdateUserRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUser(request))
  def createPermissionGroup(request: CreatePermissionGroupRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPermissionGroup(request))
  def listPermissionGroups(request: ListPermissionGroupsRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.PermissionGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listPermissionGroups(request))
  def listPermissionGroupsPaginated(request: ListPermissionGroupsRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissionGroupsPaginated(request))
  def updatePermissionGroup(request: UpdatePermissionGroupRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePermissionGroup(request))
  def deletePermissionGroup(request: DeletePermissionGroupRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.DeletePermissionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePermissionGroup(request))
  def getUser(request: GetUserRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUser(request))
  def createUser(request: CreateUserRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def updateDataset(request: UpdateDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataset(request))
  def disableUser(request: DisableUserRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.DisableUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableUser(request))
  def createChangeset(request: CreateChangesetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChangeset(request))
  def getChangeset(request: GetChangesetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChangeset(request))
  def updateChangeset(request: UpdateChangesetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChangeset(request))
  def listDatasets(request: ListDatasetsRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.Dataset.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasets(request))
  def listDatasetsPaginated(request: ListDatasetsRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def getDataset(request: GetDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataset(request))
  def getDataView(request: GetDataViewRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataView(request))
  def enableUser(request: EnableUserRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.EnableUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableUser(request))
  def resetUserPassword(request: ResetUserPasswordRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetUserPassword(request))
  def listChangesets(request: ListChangesetsRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listChangesets(request))
  def listChangesetsPaginated(request: ListChangesetsRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChangesetsPaginated(request))
  def getProgrammaticAccessCredentials(
      request: GetProgrammaticAccessCredentialsRequest
  ): ZIO[zio.aws.finspacedata.FinspaceData, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getProgrammaticAccessCredentials(request))
  def deleteDataset(request: DeleteDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataset(request))
  def getWorkingLocation(request: GetWorkingLocationRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkingLocation(request))
  def createDataView(request: CreateDataViewRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataView(request))
}
