package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  RoleArn,
  UserId,
  FirstName,
  ClientToken,
  LastName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateUserRequest(
    userId: UserId,
    `type`: Optional[zio.aws.finspacedata.model.UserType] = Optional.Absent,
    firstName: Optional[FirstName] = Optional.Absent,
    lastName: Optional[LastName] = Optional.Absent,
    apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess] = Optional.Absent,
    apiAccessPrincipalArn: Optional[RoleArn] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        firstName.map(value => FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(apiAccess.map(value => value.unwrap))(_.apiAccess)
      .optionallyWith(
        apiAccessPrincipalArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.apiAccessPrincipalArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateUserRequest.ReadOnly =
    zio.aws.finspacedata.model.UpdateUserRequest.wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateUserRequest =
      zio.aws.finspacedata.model.UpdateUserRequest(
        userId,
        `type`.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        apiAccess.map(value => value),
        apiAccessPrincipalArn.map(value => value),
        clientToken.map(value => value)
      )
    def userId: UserId
    def `type`: Optional[zio.aws.finspacedata.model.UserType]
    def firstName: Optional[FirstName]
    def lastName: Optional[LastName]
    def apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess]
    def apiAccessPrincipalArn: Optional[RoleArn]
    def clientToken: Optional[ClientToken]
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getType: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getFirstName: ZIO[Any, AwsError, FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getApiAccess: ZIO[Any, AwsError, zio.aws.finspacedata.model.ApiAccess] =
      AwsError.unwrapOptionField("apiAccess", apiAccess)
    def getApiAccessPrincipalArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("apiAccessPrincipalArn", apiAccessPrincipalArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
  ) extends zio.aws.finspacedata.model.UpdateUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.finspacedata.model.primitives.UserId(impl.userId())
    override val `type`: Optional[zio.aws.finspacedata.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.finspacedata.model.UserType.wrap(value))
    override val firstName: Optional[FirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value => zio.aws.finspacedata.model.primitives.FirstName(value))
    override val lastName: Optional[LastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value => zio.aws.finspacedata.model.primitives.LastName(value))
    override val apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAccess())
        .map(value => zio.aws.finspacedata.model.ApiAccess.wrap(value))
    override val apiAccessPrincipalArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAccessPrincipalArn())
        .map(value => zio.aws.finspacedata.model.primitives.RoleArn(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
  ): zio.aws.finspacedata.model.UpdateUserRequest.ReadOnly = new Wrapper(impl)
}
