package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListChangesetsResponse(
    changesets: Optional[
      Iterable[zio.aws.finspacedata.model.ChangesetSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse = {
    import ListChangesetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
      .builder()
      .optionallyWith(
        changesets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changesets)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly =
    zio.aws.finspacedata.model.ListChangesetsResponse.wrap(buildAwsValue())
}
object ListChangesetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListChangesetsResponse =
      zio.aws.finspacedata.model.ListChangesetsResponse(
        changesets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def changesets
        : Optional[List[zio.aws.finspacedata.model.ChangesetSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getChangesets: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("changesets", changesets)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
  ) extends zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly {
    override val changesets
        : Optional[List[zio.aws.finspacedata.model.ChangesetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changesets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.ChangesetSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
  ): zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
