package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringValueLength1to63,
  StringValueLength1to1024
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetWorkingLocationResponse(
    s3Uri: Optional[StringValueLength1to1024] = Optional.Absent,
    s3Path: Optional[StringValueLength1to1024] = Optional.Absent,
    s3Bucket: Optional[StringValueLength1to63] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse = {
    import GetWorkingLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse
      .builder()
      .optionallyWith(
        s3Uri.map(value =>
          StringValueLength1to1024.unwrap(value): java.lang.String
        )
      )(_.s3Uri)
      .optionallyWith(
        s3Path.map(value =>
          StringValueLength1to1024.unwrap(value): java.lang.String
        )
      )(_.s3Path)
      .optionallyWith(
        s3Bucket.map(value =>
          StringValueLength1to63.unwrap(value): java.lang.String
        )
      )(_.s3Bucket)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly =
    zio.aws.finspacedata.model.GetWorkingLocationResponse.wrap(buildAwsValue())
}
object GetWorkingLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetWorkingLocationResponse =
      zio.aws.finspacedata.model.GetWorkingLocationResponse(
        s3Uri.map(value => value),
        s3Path.map(value => value),
        s3Bucket.map(value => value)
      )
    def s3Uri: Optional[StringValueLength1to1024]
    def s3Path: Optional[StringValueLength1to1024]
    def s3Bucket: Optional[StringValueLength1to63]
    def getS3Uri: ZIO[Any, AwsError, StringValueLength1to1024] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
    def getS3Path: ZIO[Any, AwsError, StringValueLength1to1024] =
      AwsError.unwrapOptionField("s3Path", s3Path)
    def getS3Bucket: ZIO[Any, AwsError, StringValueLength1to63] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse
  ) extends zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly {
    override val s3Uri: Optional[StringValueLength1to1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Uri())
        .map(value =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to1024(value)
        )
    override val s3Path: Optional[StringValueLength1to1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Path())
        .map(value =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to1024(value)
        )
    override val s3Bucket: Optional[StringValueLength1to63] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Bucket())
        .map(value =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to63(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse
  ): zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly =
    new Wrapper(impl)
}
