package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.finspacedata.model.primitives.{DatasetId, DataViewId}
import scala.jdk.CollectionConverters.*
final case class GetDataViewRequest(
    dataViewId: DataViewId,
    datasetId: DatasetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest = {
    import GetDataViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest
      .builder()
      .dataViewId(DataViewId.unwrap(dataViewId): java.lang.String)
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetDataViewRequest.ReadOnly =
    zio.aws.finspacedata.model.GetDataViewRequest.wrap(buildAwsValue())
}
object GetDataViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetDataViewRequest =
      zio.aws.finspacedata.model.GetDataViewRequest(dataViewId, datasetId)
    def dataViewId: DataViewId
    def datasetId: DatasetId
    def getDataViewId: ZIO[Any, Nothing, DataViewId] = ZIO.succeed(dataViewId)
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest
  ) extends zio.aws.finspacedata.model.GetDataViewRequest.ReadOnly {
    override val dataViewId: DataViewId =
      zio.aws.finspacedata.model.primitives.DataViewId(impl.dataViewId())
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest
  ): zio.aws.finspacedata.model.GetDataViewRequest.ReadOnly = new Wrapper(impl)
}
