package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait ApiAccess {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.ApiAccess
}
object ApiAccess {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.ApiAccess
  ): zio.aws.finspacedata.model.ApiAccess = value match {
    case software.amazon.awssdk.services.finspacedata.model.ApiAccess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.ApiAccess.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.finspacedata.model.ApiAccess.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspacedata.model.ApiAccess {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApiAccess =
      software.amazon.awssdk.services.finspacedata.model.ApiAccess.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.finspacedata.model.ApiAccess {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApiAccess =
      software.amazon.awssdk.services.finspacedata.model.ApiAccess.ENABLED
  }
  case object DISABLED extends zio.aws.finspacedata.model.ApiAccess {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApiAccess =
      software.amazon.awssdk.services.finspacedata.model.ApiAccess.DISABLED
  }
}
