package zio.aws.finspacedata.model
import zio.prelude.data.Optional
import zio.aws.finspacedata.model.primitives.{ResultLimit, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPermissionGroupsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: ResultLimit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest = {
    import ListPermissionGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .maxResults(ResultLimit.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.ListPermissionGroupsRequest.ReadOnly =
    zio.aws.finspacedata.model.ListPermissionGroupsRequest.wrap(buildAwsValue())
}
object ListPermissionGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListPermissionGroupsRequest =
      zio.aws.finspacedata.model
        .ListPermissionGroupsRequest(nextToken.map(value => value), maxResults)
    def nextToken: Optional[PaginationToken]
    def maxResults: ResultLimit
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, ResultLimit] = ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest
  ) extends zio.aws.finspacedata.model.ListPermissionGroupsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
    override val maxResults: ResultLimit =
      zio.aws.finspacedata.model.primitives.ResultLimit(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsRequest
  ): zio.aws.finspacedata.model.ListPermissionGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
