package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.UserId
import scala.jdk.CollectionConverters.*
final case class UpdateUserResponse(userId: Option[UserId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse = {
    import UpdateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly =
    zio.aws.finspacedata.model.UpdateUserResponse.wrap(buildAwsValue())
}
object UpdateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateUserResponse =
      zio.aws.finspacedata.model.UpdateUserResponse(userId.map(value => value))
    def userId: Option[UserId]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
  ) extends zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly {
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserResponse
  ): zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly = new Wrapper(impl)
}
