package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  RoleArn,
  UserId,
  FirstName,
  ClientToken,
  LastName
}
import scala.jdk.CollectionConverters.*
final case class UpdateUserRequest(
    userId: UserId,
    `type`: Option[zio.aws.finspacedata.model.UserType] = None,
    firstName: Option[FirstName] = None,
    lastName: Option[LastName] = None,
    apiAccess: Option[zio.aws.finspacedata.model.ApiAccess] = None,
    apiAccessPrincipalArn: Option[RoleArn] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        firstName.map(value => FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(apiAccess.map(value => value.unwrap))(_.apiAccess)
      .optionallyWith(
        apiAccessPrincipalArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.apiAccessPrincipalArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateUserRequest.ReadOnly =
    zio.aws.finspacedata.model.UpdateUserRequest.wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateUserRequest =
      zio.aws.finspacedata.model.UpdateUserRequest(
        userId,
        `type`.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        apiAccess.map(value => value),
        apiAccessPrincipalArn.map(value => value),
        clientToken.map(value => value)
      )
    def userId: UserId
    def `type`: Option[zio.aws.finspacedata.model.UserType]
    def firstName: Option[FirstName]
    def lastName: Option[LastName]
    def apiAccess: Option[zio.aws.finspacedata.model.ApiAccess]
    def apiAccessPrincipalArn: Option[RoleArn]
    def clientToken: Option[ClientToken]
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getType: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getFirstName: ZIO[Any, AwsError, FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getApiAccess: ZIO[Any, AwsError, zio.aws.finspacedata.model.ApiAccess] =
      AwsError.unwrapOptionField("apiAccess", apiAccess)
    def getApiAccessPrincipalArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("apiAccessPrincipalArn", apiAccessPrincipalArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
  ) extends zio.aws.finspacedata.model.UpdateUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.finspacedata.model.primitives.UserId(impl.userId())
    override val `type`: Option[zio.aws.finspacedata.model.UserType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.finspacedata.model.UserType.wrap(value))
    override val firstName: Option[FirstName] = scala
      .Option(impl.firstName())
      .map(value => zio.aws.finspacedata.model.primitives.FirstName(value))
    override val lastName: Option[LastName] = scala
      .Option(impl.lastName())
      .map(value => zio.aws.finspacedata.model.primitives.LastName(value))
    override val apiAccess: Option[zio.aws.finspacedata.model.ApiAccess] = scala
      .Option(impl.apiAccess())
      .map(value => zio.aws.finspacedata.model.ApiAccess.wrap(value))
    override val apiAccessPrincipalArn: Option[RoleArn] = scala
      .Option(impl.apiAccessPrincipalArn())
      .map(value => zio.aws.finspacedata.model.primitives.RoleArn(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateUserRequest
  ): zio.aws.finspacedata.model.UpdateUserRequest.ReadOnly = new Wrapper(impl)
}
