package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  DatasetDescription,
  AliasString,
  DatasetTitle,
  ClientToken,
  DatasetId
}
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetRequest(
    clientToken: Option[ClientToken] = None,
    datasetId: DatasetId,
    datasetTitle: DatasetTitle,
    kind: zio.aws.finspacedata.model.DatasetKind,
    datasetDescription: Option[DatasetDescription] = None,
    alias: Option[AliasString] = None,
    schemaDefinition: Option[zio.aws.finspacedata.model.SchemaUnion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest = {
    import UpdateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .datasetTitle(DatasetTitle.unwrap(datasetTitle): java.lang.String)
      .kind(kind.unwrap)
      .optionallyWith(
        datasetDescription.map(value =>
          DatasetDescription.unwrap(value): java.lang.String
        )
      )(_.datasetDescription)
      .optionallyWith(
        alias.map(value => AliasString.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(schemaDefinition.map(value => value.buildAwsValue()))(
        _.schemaDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateDatasetRequest.ReadOnly =
    zio.aws.finspacedata.model.UpdateDatasetRequest.wrap(buildAwsValue())
}
object UpdateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateDatasetRequest =
      zio.aws.finspacedata.model.UpdateDatasetRequest(
        clientToken.map(value => value),
        datasetId,
        datasetTitle,
        kind,
        datasetDescription.map(value => value),
        alias.map(value => value),
        schemaDefinition.map(value => value.asEditable)
      )
    def clientToken: Option[ClientToken]
    def datasetId: DatasetId
    def datasetTitle: DatasetTitle
    def kind: zio.aws.finspacedata.model.DatasetKind
    def datasetDescription: Option[DatasetDescription]
    def alias: Option[AliasString]
    def schemaDefinition
        : Option[zio.aws.finspacedata.model.SchemaUnion.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getDatasetTitle: ZIO[Any, Nothing, DatasetTitle] =
      ZIO.succeed(datasetTitle)
    def getKind: ZIO[Any, Nothing, zio.aws.finspacedata.model.DatasetKind] =
      ZIO.succeed(kind)
    def getDatasetDescription: ZIO[Any, AwsError, DatasetDescription] =
      AwsError.unwrapOptionField("datasetDescription", datasetDescription)
    def getAlias: ZIO[Any, AwsError, AliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getSchemaDefinition
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      AwsError.unwrapOptionField("schemaDefinition", schemaDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
  ) extends zio.aws.finspacedata.model.UpdateDatasetRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val datasetTitle: DatasetTitle =
      zio.aws.finspacedata.model.primitives.DatasetTitle(impl.datasetTitle())
    override val kind: zio.aws.finspacedata.model.DatasetKind =
      zio.aws.finspacedata.model.DatasetKind.wrap(impl.kind())
    override val datasetDescription: Option[DatasetDescription] = scala
      .Option(impl.datasetDescription())
      .map(value =>
        zio.aws.finspacedata.model.primitives.DatasetDescription(value)
      )
    override val alias: Option[AliasString] = scala
      .Option(impl.alias())
      .map(value => zio.aws.finspacedata.model.primitives.AliasString(value))
    override val schemaDefinition
        : Option[zio.aws.finspacedata.model.SchemaUnion.ReadOnly] = scala
      .Option(impl.schemaDefinition())
      .map(value => zio.aws.finspacedata.model.SchemaUnion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
  ): zio.aws.finspacedata.model.UpdateDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
