package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{DatasetId, ChangesetId}
import scala.jdk.CollectionConverters.*
final case class UpdateChangesetResponse(
    changesetId: Option[ChangesetId] = None,
    datasetId: Option[DatasetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse = {
    import UpdateChangesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
      .builder()
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly =
    zio.aws.finspacedata.model.UpdateChangesetResponse.wrap(buildAwsValue())
}
object UpdateChangesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateChangesetResponse =
      zio.aws.finspacedata.model.UpdateChangesetResponse(
        changesetId.map(value => value),
        datasetId.map(value => value)
      )
    def changesetId: Option[ChangesetId]
    def datasetId: Option[DatasetId]
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
  ) extends zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly {
    override val changesetId: Option[ChangesetId] = scala
      .Option(impl.changesetId())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateChangesetResponse
  ): zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly = new Wrapper(
    impl
  )
}
