package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListUsersResponse(
    users: Option[Iterable[zio.aws.finspacedata.model.User]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListUsersResponse = {
    import ListUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListUsersResponse.ReadOnly =
    zio.aws.finspacedata.model.ListUsersResponse.wrap(buildAwsValue())
}
object ListUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListUsersResponse =
      zio.aws.finspacedata.model.ListUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def users: Option[List[zio.aws.finspacedata.model.User.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.finspacedata.model.User.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersResponse
  ) extends zio.aws.finspacedata.model.ListUsersResponse.ReadOnly {
    override val users: Option[List[zio.aws.finspacedata.model.User.ReadOnly]] =
      scala
        .Option(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.User.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersResponse
  ): zio.aws.finspacedata.model.ListUsersResponse.ReadOnly = new Wrapper(impl)
}
