package zio.aws.finspacedata.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{ResultLimit, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class ListUsersRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: ResultLimit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListUsersRequest = {
    import ListUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListUsersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .maxResults(ResultLimit.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListUsersRequest.ReadOnly =
    zio.aws.finspacedata.model.ListUsersRequest.wrap(buildAwsValue())
}
object ListUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListUsersRequest =
      zio.aws.finspacedata.model
        .ListUsersRequest(nextToken.map(value => value), maxResults)
    def nextToken: Option[PaginationToken]
    def maxResults: ResultLimit
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, ResultLimit] = ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersRequest
  ) extends zio.aws.finspacedata.model.ListUsersRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
    override val maxResults: ResultLimit =
      zio.aws.finspacedata.model.primitives.ResultLimit(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListUsersRequest
  ): zio.aws.finspacedata.model.ListUsersRequest.ReadOnly = new Wrapper(impl)
}
